<?xml version="1.0" encoding="ISO-8859-1"?>
<!-- HTML style sheet for movie-watcher XML -->
<!-- Written by Keith Wood, 4 June 1999 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/TR/WD-xsl">
  <xsl:template match="/">
    <HTML>
      <HEAD>
        <TITLE>Movie Watchers</TITLE>
      </HEAD>
      <BODY>
        <H1><A NAME="top">Welcome to Movie Watchers</A></H1>
        <P>Your source for local film entertainment.
          Have a look at <A HREF="#movies">what's on</A>,
          <A HREF="#cinemas">where</A> and 
          <A HREF="#screenings">when</A>.</P>
        <HR/>
        <H2><A NAME="movies">Movies</A></H2>
        <xsl:for-each select="movie-watcher/movies/movie" order-by="name">
          <!-- Provide link target and optional web link -->
          <A>
            <xsl:attribute name="NAME"><xsl:value-of select="@id"/></xsl:attribute>
            <xsl:if test="@url">
              <xsl:attribute name="HREF"><xsl:value-of select="@url"/></xsl:attribute>
            </xsl:if>
            <xsl:choose>
              <xsl:when test="@logo-url">
                <IMG>
                  <xsl:attribute name="SRC"><xsl:value-of select="@logo-url"/></xsl:attribute>
                  <xsl:attribute name="ALT"><xsl:value-of select="name"/></xsl:attribute>
                </IMG>
              </xsl:when>
              <xsl:otherwise>
                <H3><xsl:value-of select="name"/></H3>
              </xsl:otherwise>
            </xsl:choose>
          </A>
          <TABLE BORDER="0" WIDTH="100%">
            <TR>
              <TH ALIGN="LEFT" VALIGN="TOP" WIDTH="15%">Rating:</TH>
              <TD WIDTH="15%"><xsl:value-of select="@rating"/></TD>
              <TH ALIGN="LEFT" VALIGN="TOP" WIDTH="15%">Length:</TH>
              <TD><xsl:value-of select="length"/> mins</TD>
            </TR>
            <TR>
              <TH ALIGN="LEFT" VALIGN="TOP">Director:</TH>
              <TD COLSPAN="3"><xsl:value-of select="director"/></TD>
            </TR>
            <TR>
              <TH ALIGN="LEFT" VALIGN="TOP">Starring:</TH>
              <TD COLSPAN="3">
                <xsl:for-each select="starring/star">
                  <xsl:value-of select="."/><BR/>
                </xsl:for-each>
              </TD>
            </TR>
            <TR>
              <TH ALIGN="LEFT" VALIGN="TOP">Synopsis:</TH>
              <TD COLSPAN="3"><xsl:value-of select="synopsis"/></TD>
            </TR>
            <TR>
              <TH ALIGN="LEFT" VALIGN="TOP">Showing at:</TH>
              <TD COLSPAN="3">
                <xsl:for-each select="/movie-watcher/screenings/screening[@movie-id=context()/@id]">
                  <A>
                    <xsl:attribute name="HREF">#<xsl:value-of select="@movie-id"/>-<xsl:value-of select="@cinema-id"/></xsl:attribute>
                    <xsl:value-of select="id(@cinema-id)/name"/>
                  </A><BR/>
                </xsl:for-each>
              </TD>
            </TR>
          </TABLE>
        </xsl:for-each>    
        <P>Back to <A HREF="#top">the top</A>.</P>
        <HR/>
        <H2><A NAME="cinemas">Cinemas</A></H2>
        <xsl:for-each select="movie-watcher/cinemas/cinema" order-by="name">    
          <A>
            <xsl:attribute name="NAME"><xsl:value-of select="@id"/></xsl:attribute>
            <xsl:if test="@url">
              <xsl:attribute name="HREF"><xsl:value-of select="@url"/></xsl:attribute>
            </xsl:if>
            <xsl:choose>
              <xsl:when test="@logo-url">
                <IMG>
                  <xsl:attribute name="SRC"><xsl:value-of select="@logo-url"/></xsl:attribute>
                  <xsl:attribute name="ALT"><xsl:value-of select="name"/></xsl:attribute>
                </IMG>
              </xsl:when>
              <xsl:otherwise>
                <H3><xsl:value-of select="name"/></H3>
              </xsl:otherwise>
            </xsl:choose>
          </A>
          <TABLE BORDER="0" WIDTH="100%">
            <TR>
              <TH ALIGN="LEFT" VALIGN="TOP" WIDTH="15%">Phone:</TH>
              <TD><xsl:value-of select="phone"/></TD>
            </TR>
            <TR>
              <TH ALIGN="LEFT" VALIGN="TOP">Address:</TH>
              <TD><xsl:value-of select="address"/></TD>
            </TR>
            <TR>
              <TH ALIGN="LEFT" VALIGN="TOP">Directions:</TH>
              <TD><xsl:value-of select="directions"/></TD>
            </TR>
            <TR>
              <TH ALIGN="LEFT" VALIGN="TOP">Facilities:</TH>
              <TD>
                <xsl:if test="facilities/candy-bar">
                  Candy bar<BR/>
                </xsl:if>
                <xsl:if test="facilities/disabled-access">
                  Disabled access<BR/>
                </xsl:if>
              </TD>
            </TR>
            <TR>
              <TH ALIGN="LEFT" VALIGN="TOP">Pricing:</TH>
              <TD>
                <TABLE BORDER="1" CELLPADDING="3">
                  <TR>
                    <TH>Name</TH>
                    <TH>Times</TH>
                    <TH>Adult</TH>
                    <TH>Child</TH>
                    <TH>Discount</TH>
                  </TR>
                  <xsl:for-each select="pricing/prices">
                    <TR>
                      <TD><A>
                        <xsl:attribute name="NAME"><xsl:value-of select="@id"/></xsl:attribute>
                        <xsl:value-of select="name"/></A></TD>
                      <TD><xsl:value-of select="period"/></TD>
                      <TD ALIGN="RIGHT"><xsl:value-of select="adult"/></TD>
                      <TD ALIGN="RIGHT"><xsl:value-of select="child"/></TD>
                      <TD ALIGN="RIGHT"><xsl:value-of select="discount"/></TD>
                    </TR>
                  </xsl:for-each>
                </TABLE>
              </TD>
            </TR>
            <TR>
              <TH ALIGN="LEFT" VALIGN="TOP">Showing:</TH>
              <TD>
                <xsl:for-each select="/movie-watcher/screenings/screening[@cinema-id=context()/@id]">
                  <A>
                    <xsl:attribute name="HREF">#<xsl:value-of select="@movie-id"/>-<xsl:value-of select="@cinema-id"/></xsl:attribute>
                    <xsl:value-of select="id(@movie-id)/name"/>
                  </A><BR/>
                </xsl:for-each>
              </TD>
            </TR>
          </TABLE>
        </xsl:for-each>
        <P>Back to <A HREF="#top">the top</A>.</P>
        <HR/>
        <H2><A NAME="screenings">Screenings</A></H2>
        <xsl:for-each select="movie-watcher/screenings/screening" order-by="id(@movie-id)/name">
          <A>
            <xsl:attribute name="NAME"><xsl:value-of select="@movie-id"/>-<xsl:value-of select="@cinema-id"/></xsl:attribute>
            <H3>
              <A><xsl:attribute name="HREF">#<xsl:value-of select="@movie-id"/></xsl:attribute>
                <xsl:value-of select="id(@movie-id)/name"/>
              </A> at 
              <A><xsl:attribute name="HREF">#<xsl:value-of select="@cinema-id"/></xsl:attribute>
                <xsl:value-of select="id(@cinema-id)/name"/>
              </A>
            </H3>
          </A>
          <TABLE BORDER="0" WIDTH="100%">
            <TR>
              <TH ALIGN="LEFT" VALIGN="TOP" WIDTH="15%">Dates:</TH>
              <TD><xsl:value-of select="start-date"/>-<xsl:value-of select="end-date"/></TD>
            </TR>
            <TR>
              <TH ALIGN="LEFT" VALIGN="TOP">Features:</TH>
              <TD>Digital sound:
                <xsl:value-of select="features/digital-sound"/></TD>
            </TR>
            <TR>
              <TH ALIGN="LEFT" VALIGN="TOP">Restrictions:</TH>
              <TD>
                <xsl:choose>
                  <xsl:when test="restrictions/no-passes">
                    No passes
                  </xsl:when>
                  <xsl:otherwise>
                    None
                  </xsl:otherwise>
                </xsl:choose>
              </TD>
            </TR>
            <TR>
              <TH ALIGN="LEFT" VALIGN="TOP">Sessions:</TH>
              <TD>
                <TABLE BORDER="1" CELLPADDING="3">
                  <TR>
                    <TH>Time</TH>
                    <TH>Pricing</TH>
                  </TR>
                  <xsl:for-each select="sessions/session">
                    <TR>
                      <TD><xsl:value-of select="."/></TD>
                      <TD>
                        <A>
                          <xsl:attribute name="HREF">#<xsl:value-of select="@price-id"/></xsl:attribute>
                          <xsl:value-of select="id(@price-id)/name"/>
                        </A>
                      </TD>
                    </TR>
                  </xsl:for-each>
                </TABLE>
              </TD>
            </TR>
          </TABLE>
        </xsl:for-each>
        <P>Back to <A HREF="#top">the top</A>.</P>
        <HR/>
        <P>Movie Watcher data supplied by
          <A HREF="mailto:kbwood@iprimus.com.au">Keith Wood</A>.</P>
      </BODY>
    </HTML>
  </xsl:template>
</xsl:stylesheet>